/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.cmdprograms;

import com.tino1b2be.cmdprograms.TestResult;
import com.tino1b2be.cmdprograms.TestThread;
import com.tino1b2be.dtmfdecoder.DTMFDecoderException;
import com.tino1b2be.dtmfdecoder.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;

public class TestDTMFDecoder {
    private static String parent;
    private static String resultsFilename;

    public static void main(String[] args) throws IOException, InterruptedException, DTMFDecoderException {
        if (args.length == 2) {
            parent = args[0];
            resultsFilename = args[1];
        } else {
            TestDTMFDecoder.getInputFromUser();
        }
        double startT = System.currentTimeMillis();
        ArrayList<ArrayList<File>> testThreadFiles = new ArrayList<ArrayList<File>>();
        ArrayList<File> testFiles = FileUtil.getFiles(parent, ".wav");
        TestDTMFDecoder.setUpThreadFiles(testThreadFiles, testFiles);
        TestResult[] results = new TestResult[testFiles.size()];
        TestThread[] testThreads = TestDTMFDecoder.startThreads(testThreadFiles, results);
        int hits = 0;
        int tries = 0;
        for (TestThread thread : testThreads) {
            thread.join();
            hits += thread.hits;
            tries += thread.tries;
        }
        FileUtil.writeToFile(results, resultsFilename);
        int sum = results.length;
        double successRate = (double)TestResult.totalSuccess * 100.0 / ((double)sum * 1.0);
        double hitRate = (double)hits * 1.0 / ((double)tries * 1.0) * 100.0;
        System.out.println("Total files: " + results.length);
        System.out.println("Success Rate = " + successRate + "%");
        System.out.println("Total Hit Rate: " + Double.toString(hitRate) + "%");
        double stopT = System.currentTimeMillis();
        System.out.println("Time taken = " + Double.toString((stopT - startT) / 1000.0) + "sec.");
    }

    private static TestThread[] startThreads(ArrayList<ArrayList<File>> testThreadFiles, TestResult[] results) {
        int i;
        TestThread[] testThreads = new TestThread[testThreadFiles.size()];
        int start = 0;
        int stop = 0;
        for (i = 0; i < testThreadFiles.size() - 1; ++i) {
            stop = start + testThreadFiles.get(i).size();
            testThreads[i] = new TestThread(testThreadFiles.get(i), results, start);
            testThreads[i].start();
            start = stop;
        }
        testThreads[i] = new TestThread(testThreadFiles.get(i), results, start);
        testThreads[i].run();
        return testThreads;
    }

    private static void setUpThreadFiles(ArrayList<ArrayList<File>> testThreadFiles, ArrayList<File> testFiles) {
        int index = 0;
        do {
            ArrayList<File> threadFiles = new ArrayList<File>();
            threadFiles.add(testFiles.get(index++));
            while (index % 1000 != 0 && index < testFiles.size()) {
                threadFiles.add(testFiles.get(index));
                ++index;
            }
            testThreadFiles.add(threadFiles);
        } while (index < testFiles.size());
    }

    private static void getInputFromUser() {
        System.out.print("Please enter the directory containing the test files: ");
        Scanner sc = new Scanner(System.in);
        parent = sc.nextLine();
        System.out.print("Please enter the filename for the test results: ");
        resultsFilename = sc.nextLine();
        sc.close();
    }
}

